#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#define FALSE 0
#define TRUE 1

typedef struct bin
                 {
                   unsigned char *text;
                   int           text_length;
                   struct bin    *next;
                 } *bin_ptr;

void main(argc,argv)
 int  argc;
 char *argv[];
  {
    static int           bin_num;
    register int         byte;
    static bin_ptr       bin_head [256][2];
    static bin_ptr       bin_tail [256][2];
    static bin_ptr       current_bin_ptr;
    static int           column_num;
    static int           current_column;
    static int           current_offset;
    static int           current_pass;
    static int           fatal_error;
    static bin_ptr       next_bin_ptr;
    register int         next_pass;
    static int           num_columns;
    static unsigned char text [32768];
    static int           text_length;

    if (argc < 3)
      printf("Usage:  SORT <starting column> <column count>\n");
    else
      {
        for (bin_num=0; bin_num < 256; bin_num++)
          {
            bin_head[bin_num][0]=NULL;
            bin_tail[bin_num][0]=NULL;
          }
        current_column=atoi(argv[1]);
        num_columns=atoi(argv[2]);
        current_column+=num_columns-1;
        current_offset=current_column-1;
        byte=(int) ' ';
        fatal_error=FALSE;
        while ((byte != EOF) && (! fatal_error))
          {
            text_length=0;
            byte=(int) ' ';
            while ((byte != (int) '\n')
            &&     (byte != EOF)
            &&     (! fatal_error))
              {
                byte=getchar();
                if ((byte != (int) '\n') && (byte != EOF))
                  {
                    text[text_length]=(unsigned char) byte;
                    if (text_length == 32767)
                      {
                        fatal_error=TRUE;
                        printf("Fatal error:  line exceeds 32767 bytes.\n");
                      }
                    else
                      text_length++;
                  }
              }
            if ((! fatal_error) && (byte != EOF))
              {
                text[text_length]=(unsigned char) '\0';
                if ((current_bin_ptr
                 =(struct bin *) malloc((unsigned) sizeof(struct bin))) 
                 == NULL)
                  {
                    fatal_error=TRUE;
                    printf("Fatal error:  out of memory.\n");
                  }
                else
                  {
                    if ((current_bin_ptr->text=strdup((char *) &text[0]))
                     == NULL)
                      {
                        fatal_error=TRUE;
                        printf("Fatal error:  out of memory.\n");
                      }
                    else
                      {
                        current_bin_ptr->text_length=text_length;
                        current_bin_ptr->next=NULL;
                        if (current_column > text_length)
                          byte=(int) ' ';
                        else
                          byte=(int) text[current_offset];
                        if (bin_head[byte][0] == NULL)
                          bin_head[byte][0]=current_bin_ptr;
                        else
                          bin_tail[byte][0]->next=current_bin_ptr;  
                        bin_tail[byte][0]=current_bin_ptr;  
                      }
                  } 
              }
          }                
        if (! fatal_error)
          {
            current_pass=0;
            next_pass=1;
            for (column_num=2; column_num <= num_columns; column_num++)
              {
                for (bin_num=0; bin_num < 256; bin_num++)
                  {
                    bin_head[bin_num][next_pass]=NULL;
                    bin_tail[bin_num][next_pass]=NULL;
                  }
                current_offset--;
                current_column--;
                for (bin_num=0; bin_num < 256; bin_num++)
                  {
                    current_bin_ptr=bin_head[bin_num][current_pass];
                    while (current_bin_ptr != NULL)
                      {
                        if (current_column > current_bin_ptr->text_length)
                          byte=(int) ' ';
                        else
                          byte=(int) *((current_bin_ptr->text)+current_offset);
                        if (bin_head[byte][next_pass] == NULL)
                          bin_head[byte][next_pass]=current_bin_ptr;
                        else
                          bin_tail[byte][next_pass]->next=current_bin_ptr;  
                        bin_tail[byte][next_pass]=current_bin_ptr;  
                        next_bin_ptr=current_bin_ptr->next;
                        current_bin_ptr->next=NULL;
                        current_bin_ptr=next_bin_ptr;
                      }
                  }
                current_pass=next_pass;
                next_pass=1-next_pass;
              }
            for (bin_num=0; bin_num < 256; bin_num++)
              {
                current_bin_ptr=bin_head[bin_num][current_pass];
                while (current_bin_ptr != NULL)
                  {
                    printf("%s\n",current_bin_ptr->text);
                    next_bin_ptr=current_bin_ptr->next;
                    free((char *) current_bin_ptr->text);
                    free((char *) current_bin_ptr);
                    current_bin_ptr=next_bin_ptr;
                  }
                bin_head[bin_num][current_pass]=NULL;
                bin_tail[bin_num][current_pass]=NULL;
              }
          }
      }
    return;
  }
